<?php
session_start();

// Validar login
if (!isset($_SESSION["id_usuario"])) {
    header("Location: login.php");
    exit();
}

$nombre = $_SESSION["nombre"];
$rol = $_SESSION["rol"];
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Inicio - Sistema Planta de Maíz</title>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #f0fdf4;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }

    .menu-container {
      background-color: white;
      padding: 50px 40px;
      border-radius: 15px;
      box-shadow: 0 10px 25px rgba(0, 128, 0, 0.15);
      text-align: center;
      max-width: 500px;
      width: 100%;
    }

    h1 {
      color: #2e7d32;
      margin-bottom: 20px;
    }

    .bienvenida {
      font-size: 16px;
      color: #333;
      margin-bottom: 30px;
    }

    .menu-button {
      display: block;
      width: 100%;
      max-width: 300px;
      margin: 15px auto;
      padding: 15px;
      font-size: 18px;
      color: white;
      background-color: #2e7d32;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      transition: background-color 0.3s, transform 0.2s;
    }

    .menu-button:hover {
      background-color: #1b5e20;
      transform: translateY(-2px);
    }

    .footer {
      margin-top: 40px;
      font-size: 14px;
      color: #888;
    }
  </style>
</head>
<body>
  <div class="menu-container">
    <h1>Sistema Planta de Maíz</h1>
    <p class="bienvenida">Bienvenido, <strong><?= htmlspecialchars($nombre) ?></strong> (<?= htmlspecialchars($rol) ?>)</p>

    <!-- Botones comunes -->
    <a href="recepcion.php" class="menu-button">📥 Recepción de Materia Prima</a>
    <a href="aprobar_recepciones.php" class="menu-button">👍 Aprobar Recepcion</a>
    <a href="stock_almacen.php" class="menu-button">📦 Inventario </a>
    <!-- Solo para administradores -->
    <?php if ($rol === 'admin'): ?>
      <a href="crear_usuario.php" class="menu-button">👤 Crear Usuario</a>
      <a href="lista_usuarios.php" class="menu-button">📋 Lista de Usuarios</a>
    <?php endif; ?>

    <a href="logout.php" class="menu-button">🚪 Cerrar Sesión</a>

    <div class="footer">© <?= date('Y') ?> Comercializadora Alimentos Oriente, C.A</div>
  </div>
</body>
</html>

